// ------------------------------------------------------- //

/*
*   There is not much information in this file you can actually use.
*   (c) Spiller - OneVice
*/

// ------------------------------------------------------- //
// Configuration //

enum CONFIG
{
    EXTENSION = ".nut",
    DIRECTORY = "Scripts/"
};

// needs to be declared as global 
// for dynamic loader 

_Scripts <-
[
    "Bind",
    "Client",
    "Loader",
    "Keys",

    "UI/HUD",
    "UI/Alert",
    "UI/FloatText",
    "UI/Tooltip",
    "UI/Spawner",
    "UI/Weapons",
    "UI/Animations"
];

// ------------------------------------------------------- //
// Flags //

Flags <-
{
    HUD =
    {
        Wanted      = HUD_FLAG_WANTED,
        Clock       = HUD_FLAG_CLOCK,
        Radar       = HUD_FLAG_RADAR,
        Cash        = HUD_FLAG_CASH,
        Health      = HUD_FLAG_HEALTH,
        Weapon      = HUD_FLAG_WEAPON
    },
    
    GUI =
    {
        Visible     = GUI_FLAG_VISIBLE,
        Control     = GUI_FLAG_MOUSECTRL,
        Tags        = GUI_FLAG_TEXT_TAGS
    },

    ALIGN =
    {
        Center      = GUI_ALIGN_CENTER,
        Left        = GUI_ALIGN_LEFT,
        Right       = GUI_ALIGN_RIGHT,
        Top         = GUI_ALIGN_TOP
    },

    FONT =
    {
        Bold        = GUI_FFLAG_BOLD,
        Outline     = GUI_FFLAG_OUTLINE
    }
};

// ------------------------------------------------------- //

// load the JSON parser/encoder first
dofile("JSON.nut");

foreach(Script in _Scripts)
dofile(format("%s%s_mem%s", CONFIG.DIRECTORY, Script, CONFIG.EXTENSION));

// ------------------------------------------------------- //