class Event {
    static Store = {};
    ID = null;
    Slots = null;

    // ------------------------------------------------------- //

    constructor(ID) {
        this.ID = ID;
        this.Slots = [];
    }

    function Connect(Env, Callback) {
        this.Slots.append({
            Env = Env,
            Callback = Callback
        });
    }

    function Call(Args) {
        foreach(Slot in this.Slots) {
            local Payload = [Slot.Env];
            foreach(Arg in Args) Payload.append(Arg);

            Slot.Callback.acall(Payload);
        }
    }

    // ======================================================= //
    // Static methods

    static function Create(ID) {
        this.Store[ID] <- Event(ID);
    }

    // ------------------------------------------------------- //

    static function Get(ID) {
        if (Store.rawin(ID)) return Store[ID];
        return false;
    }

    // ------------------------------------------------------- //

    static function Bind(ID, Env, Callback) {
        local _Event = this.Get(ID);
        if (_Event) {
            _Event.Connect(Env, Callback);
        }
    }

    // ------------------------------------------------------- //

    static function Emit(ID, ...) {
        local _Event = this.Get(ID);
        if (_Event) {
            _Event.Call(vargv)
        }
    }
}

// ======================================================= //

Event.Create("ServerData");

local LoadScript = function(Script) {
    local AlreadyLoaded = _Scripts.find(Script) != null;
    if (!AlreadyLoaded) {
        _Scripts.append(Script);
        dofile(format("%s.nut", Script));
    }
}

function onServerData(Type, Data) {
    Data = mJSON.Parse(Data);
    Event.Emit("ServerData", Type, Data);

    if (Type == ReceiveType.LoadScript) {
        if (typeof(Data) == "array") {
            foreach(Script in Data) {
                LoadScript(Script)
            }
        }
    }
}

function Server::ServerData(Stream) {
    ::onServerData(Stream.ReadByte(), Stream.ReadString());
}

// ======================================================= //

function Script::ScriptLoad() {
    ::onScriptLoad();
}

function onScriptLoad() {
    _.SendData(SendType.Event, "ScriptLoad");
    Loading.Show();
    return 1;
}

// ======================================================= //

Event.Create("ScriptProcess")

function Script::ScriptProcess() {
    UI.events.scriptProcess();
    Event.Emit("ScriptProcess");
}

// ======================================================= //

Event.Create("Shoot");

function Player::PlayerShoot(Invoker, Weapon, Entity, Position) {
    Event.Emit("Shoot", Invoker.ID, Weapon, Entity);
}