local CONFIG = {
    WIDTH = 1920.0,
    HEIGHT = 1080.0
};

UI.Canvas({
    id = "WindowWrapper",
    RelativeSize = ["100%", "100%"],
    RemoveFlags = GUI_FLAG_VISIBLE,
    onGameResize = function() {
        local ScreenSize = GUI.GetScreenSize();

        _.Ratio.X = ScreenSize.X.tofloat() / CONFIG.WIDTH;
        _.Ratio.Y = ScreenSize.Y.tofloat() / CONFIG.HEIGHT;
    }
})

local LOOSE_TABLE = {
    function _get(index) {
        return null;
    }

    function _set(index, value) {
        rawset(index, value);
    }
}

// ======================================================= //

class _ {
    static Ratio = {
        X = 1,
        Y = 1
    };

    // ------------------------------------------------------- //

    static function SendData(Type, Data) {
        local _Stream = Stream();
        local IsJSON = typeof(Data) == "table" || typeof(Data) == "array";

        _Stream.WriteByte(Type);
        _Stream.WriteString(IsJSON ? mJSON.Encode(Data) : Data);

        Server.SendData(_Stream);
        return 1;
    }

    // ------------------------------------------------------- //

    static function SFX(Type) {
        this.SendData(SendType.SFX, Type);
    }

    // ------------------------------------------------------- //

    static function IdGenerator(Prefix) {
        return function(Identifier) {
            return format("%s-%s", Prefix, Identifier);
        }
    }

    static function IdGeneratorEx(Prefix) {
        return function(Identifier, ID) {
            return format("%s-%s-%s", Prefix, Identifier, ID);
        }
    }

    // ------------------------------------------------------- //

    static function Size1(Size, Swap = false) {
        local _Size = Size.tofloat();

        if (Swap) return floor(_Size * Ratio.Y);
        return _Size * Ratio.X;
    }

    static function Size2(Width, Height) {
        local _Width = Width.tofloat(), _Height = Height.tofloat();

        return VectorScreen(
            _Width * Ratio.X,
            _Height * Ratio.Y
        );
    }

    // ------------------------------------------------------- //

    static function Distance(PosX, PosY, ComX, ComY) {
        local _Distance = sqrt(((ComX - PosX) * (ComX - PosX)) + ((ComY - PosY) * (ComY - PosY)));
        return _Distance;
    }

    static function InRadius(PosX, PosY, ComX, ComY, Radius) {
        if (sqrt(((ComX - PosX) * (ComX - PosX)) + ((ComY - PosY) * (ComY - PosY))) < Radius) return true;
        else return false;
    }

    // ------------------------------------------------------- //

    static function Debounce(Env, Callback, Threshold) {
        local LastCalledAt = 0;

        return function(...) {
            local Current = Script.GetTicks();

            if (Current - LastCalledAt > Threshold) {
                LastCalledAt = Current;

                vargv.insert(0, Env);
                Callback.acall(vargv);
            }
        }
    }

    // ------------------------------------------------------- //

    static function LooseTable() {
        return {}.setdelegate(LOOSE_TABLE);
    }

    // ------------------------------------------------------- //

    static function NativeUI(Toggle, Type) {
        local IsShow = Toggle == "Show";

        switch (Type) {
            case "All": {
                local Flags = HUD_FLAG_WEAPON | HUD_FLAG_HEALTH | HUD_FLAG_RADAR | HUD_FLAG_CASH | HUD_FLAG_CLOCK | HUD_FLAG_WANTED;
                IsShow ? Hud.AddFlags(Flags) : Hud.RemoveFlags(Flags);

                break;
            }

            case "Radar":
                IsShow ? Hud.AddFlags(HUD_FLAG_RADAR) : Hud.RemoveFlags(HUD_FLAG_RADAR);
                break;
        }
    }

    // ------------------------------------------------------- //

    // it helps resizing without messing up alignment
    static function SetLabelText(ID, Text) {
        local LabelElement = UI.Label(ID);

        if (LabelElement) {
            LabelElement.Text = Text;
            LabelElement.Size.X = LabelElement.TextSize.X
        }

    }

    // ------------------------------------------------------- //

    static function GetFormattedPlayerName(Name) {
        local SplitName = split(Name, "_");
        return format("%s %s", SplitName[0], SplitName[1]);
    }
}