class PlainButtonComponent extends DecUIComponent {
    HoverColour = null;
    Colour = null;
    TextColour = null;
    LabelId = null;
    Disabled = false;

    // ------------------------------------------------------- //

    constructor(o) {
        base.constructor(o);

        this.Colour = o.Colour;
        this.HoverColour = o.HoverColour;
        this.TextColour = o.TextColour;
        this.LabelId = this.id + "-label";
        this.Disabled = o.rawin("Disabled") ? o.Disabled : false;

        this.build(o);
    }

    // ------------------------------------------------------- //

    function build(o) {
        UI.Canvas({
            id = this.id,
            align = this.align,
            Colour = this.Colour,
            Size = o.Size,
            Position = this.Position,
            context = this,
            children = [
                UI.Label({
                    id = this.LabelId,
                    Text = o.Text,
                    TextColour = o.TextColour,
                    FontName = o.FontName,
                    FontSize = o.FontSize,
                    Position = _.Size2(10, -5),
                    RemoveFlags = GUI_FLAG_MOUSECTRL,
                    postConstruct = function() {
                        this.Size.Y = _.Size1(o.Size.Y)
                    }
                })
            ],
            onHoverOver = function() {
                if (context.Disabled) return;
                this.Colour = context.HoverColour;
            },
            onHoverOut = function() {
                if (context.Disabled) return;

                this.Colour = context.Colour;
                UI.Label(context.LabelId).Alpha = context.TextColour.A;
            },
            onClick = function() {
                _.SFX("Click");
                o.onClick();
            }
        })
    }

    // ------------------------------------------------------- //

    function SetColour(Colour) {
        this.Colour = Colour;

        UI.Canvas(this.id).Colour = Colour;
        UI.Label(this.LabelId).Alpha = this.TextColour.A;
    }
}

// ======================================================= //

UI.registerComponent("PlainButton", {
    create = function(o) {
        return PlainButtonComponent(o);
    }
})