class PlainInputComponent extends DecUIComponent {
    TextColour = null;
    EditBoxId = null;
    OnClick = null;

    HasChangedDefaultText = false;

    // ------------------------------------------------------- //

    constructor(o) {
        base.constructor(o);
        this.TextColour = o.rawin("TextColour") ? o.TextColour : Colors.White220;
        this.EditBoxId = this.id + "-editbox";
        this.OnClick = o.rawin("onClick") ? o.onClick : null;

        this.build(o);
    }

    // ------------------------------------------------------- //

    function build(o) {
        UI.Canvas({
            id = this.id,
            Colour = Colour(55, 55, 55),
            Size = o.Size,
            border = {
                bottom = {
                    color = Colors.Primary,
                    size = 3
                }
            },
            Position = this.Position,
            children = [
                UI.Editbox({
                    id = this.EditBoxId,
                    Size = o.Size,
                    Colour = Colour(20, 20, 20),
                    Position = _.Size2(0, -3),
                    TextColour = Colors.Grey100,
                    FontSize = o.FontSize,
                    FontName = o.FontName,
                    Text = o.Placeholder,
                    context = this,
                    onClick = function() {
                        if (!context.HasChangedDefaultText) {
                            this.Text = "";
                            this.TextColour = context.TextColour;
                            this.MoveForward();

                            context.HasChangedDefaultText = true;
                            GUI.SetMouseEnabled(true);

                            if (context.OnClick) {
                                context.OnClick()
                            }
                        }
                    }
                })
            ]
        });
    }

    // ------------------------------------------------------- //

    function GetEditbox() {
        return UI.Editbox(this.EditBoxId);
    }

    // ------------------------------------------------------- //

    function GetText() {
        return this.GetEditbox().Text;
    }
}

// ======================================================= //

UI.registerComponent("PlainInput", {
    create = function(o) {
        return PlainInputComponent(o);
    }
})