// ------------------------------------------------------- //

/*
*   This file is a property of RTV VCMP server.
*   There is not much information in this file you can actually use though.
*
*   (c) Spiller - OneVice
*/

// ------------------------------------------------------- //
// Configuration

enum CONFIG
{
    EXTENSION = ".nut",
    DIRECTORY = "Scripts/"
};

// needs to be declared as global
// for dynamic loader

_Scripts <-
[
    "Bind",
    "Client",
    "Global",
    "Loader",
    "Timers",

    "UI/HUD",
    "UI/Base",
    "UI/Alert",
    "UI/Timer",
    "UI/Delivery",
    "UI/Stats",
    "UI/FloatText",
    "UI/Tooltip",
    "UI/Coins",
    "UI/Spawner",
    "UI/Waypoints",

    "Events/Key",
    "Events/Shoot",
    "Events/Animations"
];

// ------------------------------------------------------- //
// Flags //

Flags <-
{
    HUD =
    {
        Clock       = HUD_FLAG_CLOCK,
        Radar       = HUD_FLAG_RADAR,
        Money       = HUD_FLAG_CASH,
        Wanted      = HUD_FLAG_WANTED,
        Weapon      = HUD_FLAG_WEAPON,
        Health      = HUD_FLAG_HEALTH,
        All         = HUD_FLAG_WEAPON | HUD_FLAG_HEALTH | HUD_FLAG_RADAR | HUD_FLAG_CASH | HUD_FLAG_CLOCK | HUD_FLAG_WANTED
    },

    GUI =
    {
        Visible     = GUI_FLAG_VISIBLE,
        Control     = GUI_FLAG_MOUSECTRL,
        ThreeD      = GUI_FLAG_3D_ENTITY,
        Tags        = GUI_FLAG_TEXT_TAGS
    },

    ALIGN =
    {
        Center      = GUI_ALIGN_CENTER,
        Left        = GUI_ALIGN_LEFT,
        Right       = GUI_ALIGN_RIGHT,
        Top         = GUI_ALIGN_TOP
    },

    FONT =
    {
        Bold        = GUI_FFLAG_BOLD,
        Outline     = GUI_FFLAG_OUTLINE
    }
};

// ------------------------------------------------------- //

// load the JSON parser/encoder first
dofile("JSON.nut");

foreach(Script in _Scripts)
dofile(format("%s%s%s", CONFIG.DIRECTORY, Script, CONFIG.EXTENSION));

// ------------------------------------------------------- //